<%@ Page Title="Action Tracking" EnableEventValidation="false" Language="C#" MasterPageFile="~/Custom/BPR/BPR.Master" AutoEventWireup="true" Inherits="AdminActionTrackingByUser" Codebehind="AdminActionTrackingByUser.aspx.cs" %>
<%@ Register src="~/Controls/Custom/BPR/UserControlFromToDate.ascx" TagName="UserControlFromToDate" TagPrefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Administration > User Action Tracking"/>
    </div> 
         &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
        <asp:Button runat="server" ID="ButtonBackTop" Text="Back to Action Tracking" OnClick="ButtonBack_Click"/>
    <br />  
    <asp:Panel ID="PanelUserInfo" runat="server" GroupingText="User Information">
    <table>
        <tr>
            <td><asp:Label SkinID="DataLabel" ID="LabelforLabelUserFullName" runat="server"  AssociatedControlID="LabelUserFullName"> Name: </asp:Label>
                <asp:Label SkinID="DataLabel" ID="LabelUserFullName" runat="server"></asp:Label>
            </td>
            <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
            <td><asp:Label SkinID="DataLabel" ID="LabelforLabelUserRoles" runat="server"  AssociatedControlID="LabelUserRoles"> Role: </asp:Label>
                <asp:Label SkinID="DataLabel" ID="LabelUserRoles" runat="server"></asp:Label>
            </td>
        </tr>
    </table>
    </asp:Panel>
    <br />
    <asp:Panel ID="PanelFilter" runat="server" GroupingText="Filter">
    <table>
        <tr>
            <td colspan="6"><UserControl:UserControlFromToDate ID="UserControlDateRangeActionDate" runat="server" /></td>
            <td>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                 <asp:Button ID="Search" runat="server" onclick="ButtonSearch_Click" Text="&nbsp;Filter&nbsp;" ValidationGroup="SearchUser" />
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Button runat="server" ID="ButtonClear" Text="&nbsp;&nbsp;Clear&nbsp;&nbsp;" OnClick="ButtonClear_Click"/>
            </td>
        </tr>
    </table>
    <asp:CustomValidator ID="CustomValidatorSearchCriteria" runat="server" ErrorMessage="Please enter at least one of the following fields: Date Range."
    ValidationGroup="SearchUser" ForeColor="Red"></asp:CustomValidator>
    </asp:Panel>
    <asp:Panel ID="PanelAuditLogList" runat="server"  Width="65%">
        <asp:Label runat="server" ID="LabelNumberOfRecordsFound" Font-Bold="true"></asp:Label>
        <div style="text-align: right; width: 65%;" runat="server" id="pageSizeDiv">
            <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                    AssociatedControlID="gridViewPageSizeDdl"  Visible="false" ToolTip ="Items per page" />
                    
            <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="false" CausesValidation="false" ToolTip="Items per page"
                OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                <asp:ListItem Text="10" Value="10"></asp:ListItem>
                <asp:ListItem Text="25" Value="25"></asp:ListItem>
                <asp:ListItem Text="50" Value="50"></asp:ListItem>
                <asp:ListItem Text="100" Value="100"></asp:ListItem>
            </asp:DropDownList>
        </div>
        <asp:GridView ID="GridViewAuditLog" runat="server" AutoGenerateColumns="False" EnableModelValidation="True" Width="65%"
                AllowPaging="True" Caption="To sort please click table headings" AllowSorting="True" 
                EmptyDataText="No Records Found." PageSize="10" PagerSettings-Mode="Numeric" 
                OnPageIndexChanging='GridViewAuditLog_PageIndexChanging' OnSorting='GridViewAuditLog_Sorting' >
        <EmptyDataTemplate>
                    &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                    No Records Found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
        <Columns>            
            <asp:TemplateField HeaderText="Date Time" SortExpression="CREATED" >
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelDateTime" runat="server" Width="170" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("CREATED")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
                
            <asp:TemplateField HeaderText="Action"  SortExpression="ACTION_TYPE" >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelActionType" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("ACTION_TYPE"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

                <asp:TemplateField HeaderText="Details">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelAuditDetails" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("DETAILS"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="# Sent" >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelNumOfRegistrants" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("NUM_REGISTRANTS"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </asp:Panel>
    <asp:HiddenField runat="server" ID="HiddenFieldUserId" />
    <asp:HiddenField runat="server" ID="HiddenFieldSort" />
    <br />
     &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
        <asp:Button runat="server" ID="ButtonBackBottom" Text="Back to Action Tracking" OnClick="ButtonBack_Click"/>

</asp:Content>

